/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.utils;

import com.google.common.collect.Streams;
import java.util.stream.Stream;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class TextComponentUtils {
    public static String getFormattedStringFromComponent(ITextComponent component) {
        StringBuilder stringbuilder = new StringBuilder();
        String s = "";
        String s1 = component.getString();
        if (!s1.isEmpty()) {
            String s2 = TextComponentUtils.getFormattingCodesFromStyle(component.func_150256_b());
            if (!s2.equals(s)) {
                if (!s.isEmpty()) {
                    stringbuilder.append(TextFormatting.RESET);
                }
                stringbuilder.append(s2);
                s = s2;
            }
            stringbuilder.append(s1);
        }
        for (ITextComponent c : component.func_150253_a()) {
            String s3 = c.getString();
            if (s3.isEmpty()) continue;
            String s2 = TextComponentUtils.getFormattingCodesFromStyle(c.func_150256_b());
            if (!s2.equals(s)) {
                if (!s.isEmpty()) {
                    stringbuilder.append(TextFormatting.RESET);
                }
                stringbuilder.append(s2);
                s = s2;
            }
            stringbuilder.append(s3);
        }
        if (!s.isEmpty()) {
            stringbuilder.append(TextFormatting.RESET);
        }
        return stringbuilder.toString();
    }

    public static Stream<ITextComponent> getStreamOfComponent(ITextComponent component) {
        return Streams.concat((Stream[])new Stream[]{Stream.of(component)});
    }

    public static String getFormattingCodesFromStyle(Style style) {
        String s = "";
        Color c = style.func_240711_a_();
        if (c != null) {
            if (c.func_240742_a_() == TextFormatting.AQUA.func_211163_e().intValue()) {
                s = s + "\u00a7b";
            }
            if (c.func_240742_a_() == TextFormatting.BLACK.func_211163_e().intValue()) {
                s = s + "\u00a70";
            }
            if (c.func_240742_a_() == TextFormatting.BLUE.func_211163_e().intValue()) {
                s = s + "\u00a79";
            }
            if (c.func_240742_a_() == TextFormatting.DARK_AQUA.func_211163_e().intValue()) {
                s = s + "\u00a73";
            }
            if (c.func_240742_a_() == TextFormatting.DARK_BLUE.func_211163_e().intValue()) {
                s = s + "\u00a71";
            }
            if (c.func_240742_a_() == TextFormatting.DARK_GRAY.func_211163_e().intValue()) {
                s = s + "\u00a78";
            }
            if (c.func_240742_a_() == TextFormatting.DARK_GREEN.func_211163_e().intValue()) {
                s = s + "\u00a72";
            }
            if (c.func_240742_a_() == TextFormatting.DARK_PURPLE.func_211163_e().intValue()) {
                s = s + "\u00a75";
            }
            if (c.func_240742_a_() == TextFormatting.DARK_RED.func_211163_e().intValue()) {
                s = s + "\u00a74";
            }
            if (c.func_240742_a_() == TextFormatting.GOLD.func_211163_e().intValue()) {
                s = s + "\u00a76";
            }
            if (c.func_240742_a_() == TextFormatting.GRAY.func_211163_e().intValue()) {
                s = s + "\u00a77";
            }
            if (c.func_240742_a_() == TextFormatting.GREEN.func_211163_e().intValue()) {
                s = s + "\u00a7a";
            }
            if (c.func_240742_a_() == TextFormatting.LIGHT_PURPLE.func_211163_e().intValue()) {
                s = s + "\u00a7d";
            }
            if (c.func_240742_a_() == TextFormatting.RED.func_211163_e().intValue()) {
                s = s + "\u00a7c";
            }
            if (c.func_240742_a_() == TextFormatting.WHITE.func_211163_e().intValue()) {
                s = s + "\u00a7f";
            }
            if (c.func_240742_a_() == TextFormatting.YELLOW.func_211163_e().intValue()) {
                s = s + "\u00a7e";
            }
        }
        if (style.func_150223_b()) {
            s = s + "\u00a7l";
        }
        if (style.func_150242_c()) {
            s = s + "\u00a7o";
        }
        if (style.func_150233_f()) {
            s = s + "\u00a7k";
        }
        if (style.func_150236_d()) {
            s = s + "\u00a7m";
        }
        if (style.func_150234_e()) {
            s = s + "\u00a7n";
        }
        return s;
    }

    public static String toHexString(int red, int green, int blue) {
        String hex = String.format("#%02X%02X%02X", red, green, blue);
        return hex;
    }

    public static StringTextComponent getWithGradient(java.awt.Color start, String text, java.awt.Color end) {
        StringTextComponent sc = new StringTextComponent("");
        int length = text.length();
        int i = 0;
        for (char c : text.toCharArray()) {
            int red = (int)((float)start.getRed() + (float)(end.getRed() - start.getRed()) / (float)(length - 1) * (float)i);
            int green = (int)((float)start.getGreen() + (float)(end.getGreen() - start.getGreen()) / (float)(length - 1) * (float)i);
            int blue = (int)((float)start.getBlue() + (float)(end.getBlue() - start.getBlue()) / (float)(length - 1) * (float)i);
            StringTextComponent charComp = new StringTextComponent("" + c);
            Style s = charComp.func_150256_b();
            Color textColor = Color.func_240745_a_((String)TextComponentUtils.toHexString(red, green, blue));
            Style colored = s.func_240718_a_(textColor);
            charComp.func_230530_a_(colored);
            sc.func_230529_a_((ITextComponent)charComp);
            ++i;
        }
        return sc;
    }
}

